<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'nic_number',
        'profile_image',
    ];

    public function rentals()
    {
        return $this->hasMany(Rental::class);
    }

    public function documents()
    {
        return $this->morphMany(Document::class, 'model');
    }
}
