<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  ...$roles
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Check if user is approved and not locked
        if (!$user->approved || $user->locked) {
            \Illuminate\Support\Facades\Auth::logout();
            return redirect()->route('login')->withErrors(['email' => 'Your account is not approved or has been locked.']);
        }

        // If roles are specified, check if user has one of them
        if (!empty($roles)) {
            $userRoleName = $user->role?->name;
            if (!in_array($userRoleName, $roles)) {
                abort(403, 'Unauthorized access.');
            }
        }

        return $next($request);
    }
}
