<?php

namespace App\Http\Controllers;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Http\Request;

class ShopController extends Controller
{
  public function index()
  {
    $shops = Shop::with('manager')->paginate(10);
    $managers = User::whereHas('role', function($query) {
      $query->where('name', 'shop_manager');
    })->orWhereHas('role', function($query) {
      $query->where('name', 'admin');
    })->get();
    return view('module.shop.index', compact('shops', 'managers'));
  }

  public function create()
  {
    $managers = User::all();
    return view('shops.create', compact('managers'));
  }

  public function store(Request $request)
  {
    $request->validate([
      'name' => 'required',
      'code' => 'required|unique:shops',
      'address' => 'required',
      'phone' => 'required',
      'manager_user_id' => 'nullable|exists:users,id',
    ]);

    Shop::create($request->all());

    return redirect()->route('shops.index')->with('success', 'Shop created successfully');
  }

  public function update(Request $request, Shop $shop)
  {
    $request->validate([
      'name' => 'required',
      'code' => 'required|unique:shops,code,' . $shop->id,
      'address' => 'required',
      'phone' => 'required',
      'manager_user_id' => 'nullable|exists:users,id',
    ]);

    $shop->update($request->all());

    return redirect()->route('shops.index')
      ->with('success', 'Shop updated successfully');
  }

  public function destroy(Shop $shop)
  {
    $shop->delete();

    return redirect()->route('shops.index')
      ->with('success', 'Shop deleted successfully');
  }
}
