<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class RentalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $rentals = \App\Models\Rental::with(['shop', 'customer', 'rentedBy', 'agreement', 'invoices'])->paginate(10);
        return view('module.rental.index', compact('rentals'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // Get next available rental ID (handle case when no rentals exist)
        $maxId = \App\Models\Rental::withTrashed()->max('id');
        $nextRentalId = $maxId ? $maxId + 1 : 1;
        $shops = \App\Models\Shop::all();
        $customers = \App\Models\Customer::all();
        $equipments = \App\Models\Equipment::with('category')->get();
        $user = \Illuminate\Support\Facades\Auth::user();

        return view('module.rental.create', compact('nextRentalId', 'shops', 'customers', 'equipments', 'user'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(\App\Models\Rental $rental)
    {
        // Load rental with agreement
        $rental->load('agreement');
        
        // Auto-create agreement if it doesn't exist (for older rentals)
        if (!$rental->agreement) {
            $agreement = \App\Models\RentalAgreement::create([
                'rental_id' => $rental->id,
                'agreement_number' => 'AGR-' . $rental->id,
                'issued_at' => $rental->rental_date ?? now(),
                'status' => 'pending',
            ]);
            $rental->refresh();
        }
        
        // Redirect to agreement preview
        return redirect()->route('agreements.preview', $rental->agreement);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
