<?php

namespace App\Http\Controllers;

use App\Models\Rental;
use App\Models\RentalAgreement;
use Illuminate\Http\Request;

class RentalAgreementController extends Controller
{
    public function preview(RentalAgreement $agreement)
    {
        $agreement->load(['rental.shop', 'rental.customer', 'rental.rentalItems.equipment', 'rental.rentedBy', 'rental.invoices']);
        return view('module.agreement.preview', compact('agreement'));
    }

    public function show(RentalAgreement $agreement)
    {
        $agreement->load(['rental.shop', 'rental.customer', 'rental.rentalItems.equipment', 'rental.rentedBy']);
        return view('module.agreement.show', compact('agreement'));
    }

    public function download(RentalAgreement $agreement)
    {
        $agreement->load(['rental.shop', 'rental.customer', 'rental.rentalItems.equipment', 'rental.rentedBy']);

        $pdf = \Barryvdh\DomPDF\Facade\Pdf::loadView('agreements.pdf', compact('agreement'));

        // Save PDF
        $pdfPath = 'agreements/' . $agreement->agreement_number . '.pdf';
        \Storage::disk('public')->put($pdfPath, $pdf->output());
        $agreement->update(['pdf_path' => $pdfPath]);

        return $pdf->download($agreement->agreement_number . '.pdf');
    }

    public function markSigned(RentalAgreement $agreement)
    {
        $agreement->markAsSigned();

        return redirect()->back()->with('success', 'Agreement marked as signed successfully.');
    }

    public function markEquipmentHandedOver(RentalAgreement $agreement)
    {
        $agreement->markEquipmentHandedOver();

        return redirect()->back()->with('success', 'Equipment marked as handed over successfully.');
    }
}
