<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AuthController extends Controller
{
  // Show login form
  public function showLoginForm()
  {
    return view('auth.login'); // Create this Blade view
  }

  // Handle login
  public function login(Request $request)
  {
    $request->validate([
      'email' => 'required|email',
      'password' => 'required|string',
    ]);

    $user = User::where('email', $request->email)->first();

    if (!$user) {
      return back()->withErrors(['email' => 'Email not found'])->withInput();
    }

    if (!$user->approved) {
      return back()->withErrors(['email' => 'Your account is not approved yet'])->withInput();
    }

    if ($user->locked) {
      return back()->withErrors(['email' => 'Your account is locked'])->withInput();
    }

    if (!Hash::check($request->password, $user->password)) {
      return back()->withErrors(['password' => 'Invalid password'])->withInput();
    }

    // Login the user
    Auth::login($user, $request->filled('remember'));

    // Redirect based on role
    switch ($user->role_id) {
      case 1:
        return redirect()->route('dashboard');
      case 2:
        return redirect()->route('dashboard');
      default:
        return redirect()->route('dashboard');
    }
  }

  // Logout
  public function logout()
  {
    Auth::logout();
    return redirect()->route('login');
  }
}
