<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Shop;
use App\Models\User;
use Illuminate\Http\Request;

class ShopController extends Controller
{
  // List shops with pagination
  public function index()
  {
    $shops = Shop::with('manager')->paginate(10);

    return response()->json([
      'success' => true,
      'shops' => $shops
    ]);
  }

  // Store new shop
  public function store(Request $request)
  {
    $validated = $request->validate([
      'name' => 'required',
      'code' => 'required|unique:shops',
      'address' => 'required',
      'phone' => 'required',
      'manager_user_id' => 'nullable|exists:users,id',
    ]);

    $shop = Shop::create($validated);

    return response()->json([
      'success' => true,
      'message' => 'Shop created successfully',
      'data' => $shop->load('manager')
    ]);
  }

  // Update existing shop
  public function update(Request $request, Shop $shop)
  {
    //return response()->json($request->all());
    $validated = $request->validate([
      'name' => 'required',
      'code' => 'required|unique:shops,code,' . $shop->id,
      'address' => 'required',
      'phone' => 'required',
      'manager_user_id' => 'nullable|exists:users,id',
    ]);

    $shop->update($validated);

    return response()->json([
      'success' => true,
      'message' => 'Shop updated successfully',
      'data' => $shop->load('manager')
    ]);
  }

  // Delete a shop
  public function destroy(Shop $shop)
  {
    $shop->delete();

    return response()->json([
      'success' => true,
      'message' => 'Shop deleted successfully'
    ]);
  }

  // Optional: show a single shop
  public function show(Shop $shop)
  {
    return response()->json([
      'success' => true,
      'shop' => $shop->load('manager')
    ]);
  }
}
