<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\RentalAgreement;
use Illuminate\Http\Request;

class RentalAgreementController extends Controller
{
    public function show(RentalAgreement $agreement)
    {
        return response()->json([
            'success' => true,
            'data' => $agreement->load(['rental.shop', 'rental.customer', 'rental.rentalItems.equipment', 'rental.rentedBy'])
        ]);
    }

    public function markSigned(Request $request, RentalAgreement $agreement)
    {
        $agreement->markAsSigned();

        return response()->json([
            'success' => true,
            'message' => 'Agreement marked as signed successfully',
            'data' => $agreement
        ]);
    }

    public function markEquipmentHandedOver(Request $request, RentalAgreement $agreement)
    {
        $agreement->markEquipmentHandedOver();

        return response()->json([
            'success' => true,
            'message' => 'Equipment marked as handed over successfully',
            'data' => $agreement
        ]);
    }
}





