<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class AuthController extends Controller
{
  // Login and generate token
  public function login(Request $request)
  {
    $request->validate([
      'email' => 'required|email',
      'password' => 'required|string',
    ]);

    $user = User::where('email', $request->email)->first();

    if (!$user) {
      return response()->json(['message' => 'Email not found'], 404);
    }

    if (!$user->approved) {
      return response()->json(['message' => 'Your account is not approved yet'], 403);
    }

    if ($user->locked) {
      return response()->json(['message' => 'Your account is locked'], 403);
    }

    if (!Hash::check($request->password, $user->password)) {
      return response()->json(['message' => 'Invalid password'], 401);
    }

    // Create API token
    $token = $user->createToken('api-token')->plainTextToken;

    return response()->json([
      'message' => 'Login successful',
      'user' => $user,
      'token' => $token,
    ]);
  }

  // Logout and revoke token
  public function logout(Request $request)
  {
    $request->user()->currentAccessToken()->delete();

    return response()->json(['message' => 'Logged out successfully']);
  }

  // Return current authenticated user
  public function me(Request $request)
  {
    return response()->json($request->user());
  }
}
