<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Stock;
use App\Services\StockService;
use Illuminate\Http\Request;

class StockController extends Controller
{
    public function index()
    {
        $stocks = Stock::with(['shop', 'equipment'])->paginate(10);
        return view('module.stock.index', compact('stocks'));
    }

    public function adjust(Request $request)
    {
        $validated = $request->validate([
            'shop_id' => 'required|exists:shops,id',
            'equipment_id' => 'required|exists:equipments,id',
            'quantity' => 'required|integer',
            'notes' => 'nullable|string',
        ]);

        StockService::adjustStock(
            $validated['shop_id'],
            $validated['equipment_id'],
            $validated['quantity'],
            $validated['notes'] ?? 'Manual stock adjustment'
        );

        return response()->json([
            'success' => true,
            'message' => 'Stock adjusted successfully'
        ]);
    }

    public function add(Request $request)
    {
        $validated = $request->validate([
            'shop_id' => 'required|exists:shops,id',
            'equipment_id' => 'required|exists:equipments,id',
            'quantity' => 'required|integer|min:1',
            'notes' => 'nullable|string',
        ]);

        StockService::addStock(
            $validated['shop_id'],
            $validated['equipment_id'],
            $validated['quantity'],
            $validated['notes'] ?? 'Stock added'
        );

        return response()->json([
            'success' => true,
            'message' => 'Stock added successfully'
        ]);
    }
}
